/*
 * Decompiled with CFR 0.152.
 */
package net.famkruithof.logagent;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

class LogConfigurator {
    private static final String DEFAULT_CONFIG = "net/famkruithof/logagent/default.conf";
    private static final String CLASS = LogConfigurator.class.getName();
    private Set<String> applicable = new HashSet<String>();
    private Set<String> excluded = new HashSet<String>();
    private Set<String> excludedMethods = new HashSet<String>();
    private static Logger log = Logger.getLogger(CLASS);
    private static final String INCLUDED_KEY = "INCLUDE";
    private static final String EXCLUDED_KEY = "EXCLUDE";
    private static final String EXMETHOD_KEY = "EXMETHOD";
    private static final String OUTPUT_KEY = "OUTPUT";
    private static final String CONFIG_KEY = "CONFIG";
    private String output;

    LogConfigurator(String agentArgs) {
        File f;
        InputStream in = null;
        String config = this.getConfigFile(agentArgs);
        if (config != null && !"".equals(config) && (f = new File(config)).canRead() && f.isFile()) {
            try {
                in = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        if (in == null) {
            in = ClassLoader.getSystemClassLoader().getResourceAsStream(DEFAULT_CONFIG);
            if (config != null && !"".equals(config)) {
                log.logp(Level.WARNING, CLASS, "<init>", "Could not open config file " + config + " using default config.");
            }
        }
        try {
            this.parseConfig(in);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.defaultConfig();
            log.logp(Level.WARNING, CLASS, "<init>", "Error loading config, using built in config.");
        }
        this.updateConfig(agentArgs);
        try {
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void updateConfig(String agentArgs) {
        if (agentArgs == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(agentArgs, ":");
        while (tok.hasMoreElements()) {
            this.executeCmd(tok.nextToken(), '=');
        }
    }

    private String getConfigFile(String agentArgs) {
        if (agentArgs == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(agentArgs, ":");
        while (tok.hasMoreElements()) {
            String str = tok.nextToken();
            int cmdend = str.indexOf(61);
            if (cmdend == -1) continue;
            String cmd = str.substring(0, cmdend).toUpperCase();
            String arg = str.substring(cmdend + 1).trim();
            if (!CONFIG_KEY.equalsIgnoreCase(cmd)) continue;
            return arg;
        }
        return null;
    }

    private void defaultConfig() {
        this.excluded.add("java");
        this.excluded.add("javax");
        this.excluded.add("net/famkruithof/logagent");
        this.excluded.add("sun");
        this.excluded.add("org/apache/bcel");
        this.excluded.add("com/sun");
        this.excluded.add("org/ietf/jgss");
        this.excluded.add("org/omg");
        this.excluded.add("org/w3c/dom");
        this.excluded.add("org/xml/sax");
        this.excluded.add("org/omg/CORBA_2_3");
        this.excludedMethods.add("toString");
        this.output = "logagent.xml";
    }

    private void parseConfig(InputStream config) throws IOException {
        BufferedReader read = new BufferedReader(new InputStreamReader(config));
        String line = read.readLine();
        while (line != null) {
            int comment = line.indexOf(35);
            if (comment > 0) {
                line = line.substring(0, comment);
            }
            if (!"".equals(line = comment == 0 ? "" : line.trim())) {
                this.executeCmd(line, ' ');
            }
            line = read.readLine();
        }
    }

    private void executeCmd(String line, char sep) {
        int cmdend = line.indexOf(sep);
        if (cmdend != -1) {
            String cmd = line.substring(0, cmdend).toUpperCase();
            String arg = line.substring(cmdend + 1).trim();
            if (INCLUDED_KEY.equals(cmd)) {
                this.applicable.add(LogConfigurator.getPkgName(arg));
            } else if (EXCLUDED_KEY.equals(cmd)) {
                this.excluded.add(LogConfigurator.getPkgName(arg));
            } else if (EXMETHOD_KEY.equals(cmd)) {
                this.excludedMethods.add(arg);
            } else if (OUTPUT_KEY.equals(cmd)) {
                this.output = arg;
            }
        }
    }

    private static String getPkgName(String arg) {
        String result = arg.replace('.', '/');
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    String getOutput() {
        return this.output;
    }

    boolean isApplicable(String className) {
        String name = className;
        while (name.length() > 0) {
            if (this.applicable.contains(name)) {
                return true;
            }
            if (this.excluded.contains(name)) {
                return false;
            }
            int idx = name.lastIndexOf(47);
            if (idx > 0) {
                name = name.substring(0, name.lastIndexOf(47));
                continue;
            }
            name = "";
        }
        return this.applicable.size() == 0;
    }

    boolean isApplicable(String className, String methodName) {
        return !this.excludedMethods.contains(methodName);
    }
}

