package com.titan.clients;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.MapMessage;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;

import com.titan.access.DataAccess;
import com.titan.domain.Cabin;
import com.titan.domain.Cruise;
import com.titan.domain.Customer;
import com.titan.processpayment.CreditCardDO;


public class JmsClient_ReservationProducer
{
   
   public static void main(String [] args) throws Exception
   {
      
      if(args.length != 1)
         throw new Exception("Usage: java JmsClient_ReservationProducer <count>");
      
      int count = new Integer(args[0]).intValue();
      
      Context jndiContext = getInitialContext();
      
      DataAccess access =(DataAccess)jndiContext.lookup(DataAccess.class.getName());
      access.initializeDB();
      List<Cruise> cruises = access.getCruises();
      Map<Cruise,List<Cabin>> cabins = new HashMap<Cruise,List<Cabin>>();
      for(Cruise cruise:cruises)
      {
          cabins.put(cruise, access.getCabins(cruise.getId()));
      }
      List<Customer> customers = access.getCustomers();
      try
      {
         access.makePaymentDbTable();
      }
      catch (Exception ignored) {}

      ConnectionFactory factory =(ConnectionFactory)jndiContext.lookup("jms/ConnectionFactory");
      
      Queue reservationQueue =(Queue)jndiContext.lookup("queue/titan-ReservationQueue");
      Queue ticketQueue =(Queue)jndiContext.lookup("queue/titan-TicketQueue");
      
      Connection connect = factory.createConnection();      
      Session session = connect.createSession(false, Session.AUTO_ACKNOWLEDGE);
      MessageProducer sender = session.createProducer(reservationQueue);
      
      for(int i = 0; i < count; i++)
      {         
         MapMessage message = session.createMapMessage();
         
         message.setJMSReplyTo(ticketQueue);  // Used in ReservationProcessor to send Tickets back out
         
         message.setStringProperty("MessageFormat", "Version 3.4");
         
         Cruise currentCruise = cruises.get(i%cruises.size());
         message.setInt("CruiseID", currentCruise.getId());
         message.setInt("CustomerID", customers.get(i%customers.size()).getId());  // either Customer 1 or 2, all we've got in database
         List<Cabin> validCabins = cabins.get(currentCruise);
         message.setInt("CabinID", validCabins.get(i%validCabins.size()).getId());  // cabins 100-109 only
         message.setDouble("Price",(double)1000 + i);
         
         // the card expires in about 30 days
         //
         Date expDate = new Date(System.currentTimeMillis() + 30*24*60*60*1000L);
         
         message.setString("CreditCardNum", "5549861006051975");
         message.setLong("CreditCardExpDate", expDate.getTime());
         message.setString("CreditCardType", CreditCardDO.MASTER_CARD);
         
         System.out.println("Sending reservation message #"+i);
         sender.send(message);
      }
      new Thread(new Runnable(){

        @Override
        public void run() {
            try {
                Thread.sleep(10000);
            } catch (InterruptedException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            System.exit(0);
        }
          
      }).start();
      connect.close();
   }
   
   public static Context getInitialContext()
      throws javax.naming.NamingException
   {
      return new InitialContext();
   }
}
