package com.titan.clients;

import java.util.Collection;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;

import com.titan.domain.Address;
import com.titan.domain.CreditCard;
import com.titan.domain.Customer;
import com.titan.domain.Phone;
import com.titan.domain.Reservation;

public class ClientSupport {

    public static void waitSomeTime() {
        try {
            Thread.sleep(30000);
        } catch (InterruptedException e) {

        }
    }

    public static void printCustomer(EntityManagerFactory factory, int id) {
        EntityManager manager = factory.createEntityManager();
        try {
            Customer custCopy = manager.find(Customer.class, id);
            
            Address addr = custCopy.getAddress();
            CreditCard cc = custCopy.getCreditCard();
            Collection<Phone> phones = custCopy.getPhoneNumbers();
            Collection<Reservation> reservations = custCopy.getReservations();
            System.out.println("Print Customer :" + custCopy.getId() + " "
                    + custCopy.getFirstName() + " " + custCopy.getLastName()
                    + " " + (custCopy.getHasGoodCredit() ? "Good" : "Bad")
                    + " Credit");
            if (addr != null) {
                System.out.println(

                "Address :" + addr.getId() + " " + addr.getStreet() + " "
                        + addr.getZip() + " " + addr.getCity() + " "
                        + addr.getState());
            }
            if (cc != null) {
                System.out.println("CreditCard :" + cc.getId() + " "
                        + cc.getCreditOrganization() + " " + cc.getNumber()
                        + " " + cc.getExpirationDate() + " "
                        + cc.getNameOnCard() + " Cust id:"
                        + cc.getCustomer().getId());
            }
            for (Phone phone : phones) {
                System.out.println("Phone :" + phone.getId() + " "
                        + phone.getNumber() + " " + phone.getType());
            }

            for (Reservation res : reservations) {
                System.out.println("Reservation :" + res.getId() + " "
                        + res.getAmountPaid() + " " + res.getDate() + " "
                        + res.getCruise().getName());
            }
        } finally {
            manager.close();
        }
    }

}
