package com.titan.travelagent;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;

import com.titan.domain.Cabin;

@Stateless
public class TravelAgentBean implements TravelAgentRemote
{
   @PersistenceUnit(unitName="titan") private EntityManagerFactory factory;
   @PersistenceContext(unitName="titan") private EntityManager manager;
    
   public void createCabin(Cabin cabin)
   {
      manager.persist(cabin);
   }

   public Cabin findCabin(int pKey)
   {
      return manager.find(Cabin.class, pKey);
   }
   
   public void updateCabin(Cabin cabin)
   {
      manager.merge(cabin);
   }
   
   public void flushModeExample()
   {
      EntityManager createdManager = factory.createEntityManager();
        
      try
      {
         createdManager.setFlushMode(FlushModeType.COMMIT);
         Cabin newCabin2 = new Cabin();
         newCabin2.setId(2);
         newCabin2.setName("Another Cabin");
         newCabin2.setBedCount(1);
         createdManager.persist(newCabin2);

         Cabin cabin2 = manager.find(Cabin.class, 2);
         if (cabin2 != null) 
         {
            throw new RuntimeException("newCabin2 should not be flushed yet");
         }

         try
         {
             Cabin cabin2found = (Cabin)createdManager.createQuery("SELECT c FROM Cabin c WHERE c.id = 2").getSingleResult();
             throw new RuntimeException("newCabin2 should not be flushed yet");
         }
         catch (NoResultException e)
         {
             // expected
         }
         
         createdManager.setFlushMode(FlushModeType.AUTO);
         Cabin cabin2found = (Cabin)createdManager.createQuery("SELECT c FROM Cabin c WHERE c.id = 2").getSingleResult();
         if (!cabin2found.getName().equals("Another Cabin"))
         {
             throw new RuntimeException("Expected to have found cabin 2 with correct name");
         }
         
         cabin2 = manager.find(Cabin.class, 2);
         if (cabin2 != null)
         {
            throw new RuntimeException("newCabin2 should not be visible yet as transaction is not commited yet.");
         }
         /*
         createdManager.setFlushMode(FlushModeType.COMMIT);
         newCabin2.setBedCount(99);

         cabin1 = (Cabin)createdManager.createQuery("SELECT c FROM Cabin c WHERE c.id = 1").getSingleResult();

         manager.refresh(cabin2);
         if (cabin2.getBedCount() == 99) 
         {
            throw new RuntimeException("should not be 99 yet with COMMIT and a query");
         }

         createdManager.flush();

         manager.refresh(cabin2);
         if (cabin2.getBedCount() != 99)
         {
            throw new RuntimeException("should be 99 yet with a flush");
         }*/
      }
      finally
      {
         createdManager.close();
      }
   }
}
