/*
 * Decompiled with CFR 0.152.
 */
package com.titan.domain;

import com.titan.domain.Address;
import com.titan.domain.CreditCard;
import com.titan.domain.Phone;
import com.titan.domain.Reservation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EntityResult;
import javax.persistence.FetchType;
import javax.persistence.FieldResult;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.Table;

@Entity
@Table(name="CUST_TABLE")
@SqlResultSetMapping(name="customerAndCreditCardMapping", entities={@EntityResult(entityClass=Customer.class), @EntityResult(entityClass=CreditCard.class, fields={@FieldResult(name="id", column="CC_ID"), @FieldResult(name="number", column="CC_NUMBER")})})
public class Customer
implements Serializable {
    private int id;
    private String firstName;
    private String lastName;
    private boolean hasGoodCredit;
    private Address address;
    private Collection<Phone> phoneNumbers = new ArrayList<Phone>();
    private CreditCard creditCard;
    private Collection<Reservation> reservations = new ArrayList<Reservation>();

    @Id
    @GeneratedValue
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public boolean getHasGoodCredit() {
        return this.hasGoodCredit;
    }

    public void setHasGoodCredit(boolean flag) {
        this.hasGoodCredit = flag;
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="ADDRESS_ID")
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="credit_card_id")
    public CreditCard getCreditCard() {
        return this.creditCard;
    }

    public void setCreditCard(CreditCard card) {
        this.creditCard = card;
    }

    @OneToMany(cascade={CascadeType.ALL})
    public Collection<Phone> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(Collection<Phone> phones) {
        this.phoneNumbers = phones;
    }

    @ManyToMany(mappedBy="customers", cascade={CascadeType.REFRESH})
    public Collection<Reservation> getReservations() {
        return this.reservations;
    }

    public void setReservations(Collection<Reservation> reservations) {
        this.reservations = reservations;
    }
}

