/*
 * Decompiled with CFR 0.152.
 */
package com.titan.clients;

import com.titan.clients.InitializeDB;
import com.titan.domain.Customer;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;

public class ParametersAndPaging {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        HashMap map = new HashMap();
        EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)"titan", map);
        EntityManager entityManager = factory.createEntityManager();
        entityManager.getTransaction().begin();
        try {
            List results;
            System.out.println("Initialize DB");
            InitializeDB.initialize(entityManager);
            System.out.println();
            System.out.println();
            System.out.println("Find Bill Burke by named parameter");
            Customer cust = ParametersAndPaging.findCustomerByNamedParameter(entityManager, "Bill", "Burke");
            System.out.println("Bill Burke's cust id: " + cust.getId());
            System.out.println();
            System.out.println();
            System.out.println("Find Gavin King by indexed parameter");
            cust = ParametersAndPaging.findCustomerByIndexedParameter(entityManager, "Gavin", "King");
            System.out.println("Gavin King's cust id: " + cust.getId());
            System.out.println();
            System.out.println();
            System.out.println("Output all customers via paging");
            int first = 0;
            int max = 2;
            do {
                results = ParametersAndPaging.getCustomers(entityManager, max, first);
                for (Customer c : results) {
                    System.out.println(c.getFirstName() + " " + c.getLastName());
                }
                entityManager.clear();
                first += results.size();
            } while (results.size() > 0);
        }
        finally {
            entityManager.getTransaction().commit();
            entityManager.close();
            factory.close();
        }
    }

    public static Customer findCustomerByNamedParameter(EntityManager entityManager, String first, String last) {
        Query query = entityManager.createQuery("SELECT c from Customer c  where c.firstName=:first and c.lastName=:last");
        query.setParameter("first", (Object)first);
        query.setParameter("last", (Object)last);
        return (Customer)query.getSingleResult();
    }

    public static Customer findCustomerByIndexedParameter(EntityManager entityManager, String first, String last) {
        Query query = entityManager.createQuery("SELECT c from Customer c  where c.firstName=?1 and c.lastName=?2");
        query.setParameter(1, (Object)first);
        query.setParameter(2, (Object)last);
        return (Customer)query.getSingleResult();
    }

    public static List getCustomers(EntityManager entityManager, int max, int index) {
        Query query = entityManager.createQuery("SELECT c from Customer c");
        return query.setMaxResults(max).setFirstResult(index).getResultList();
    }
}

