/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class LocalDeclaration
extends AbstractVariableDeclaration {
    public LocalVariableBinding binding;

    public LocalDeclaration(char[] name, int sourceStart, int sourceEnd) {
        this.name = name;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
        this.declarationEnd = sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (flowInfo.isReachable()) {
            this.bits |= 0x40000000;
        }
        if (this.initialization == null) {
            return flowInfo;
        }
        int nullStatus = this.initialization.nullStatus(flowInfo);
        flowInfo = this.initialization.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        flowInfo.markAsDefinitelyAssigned(this.binding);
        switch (nullStatus) {
            case 1: {
                flowInfo.markAsDefinitelyNull(this.binding);
                break;
            }
            case -1: {
                flowInfo.markAsDefinitelyNonNull(this.binding);
            }
        }
        return flowInfo;
    }

    public void checkModifiers() {
        if ((this.modifiers & 0xFFFF & 0xFFFFFFEF) != 0) {
            this.modifiers = this.modifiers & 0xFFBFFFFF | 0x800000;
        }
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if (this.binding.resolvedPosition != -1) {
            codeStream.addVisibleLocalVariable(this.binding);
        }
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        if (this.initialization != null) {
            Constant inlinedValue = this.initialization.constant;
            if (inlinedValue != NotAConstant) {
                if (this.binding.resolvedPosition != -1) {
                    int initPC = codeStream.position;
                    codeStream.generateConstant(inlinedValue, this.initialization.implicitConversion);
                    codeStream.recordPositionsFrom(initPC, this.initialization.sourceStart);
                    codeStream.store(this.binding, false);
                    this.binding.recordInitializationStartPC(codeStream.position);
                }
            } else {
                this.initialization.generateCode(currentScope, codeStream, true);
                if (this.binding.resolvedPosition != -1) {
                    if (this.binding.type.isArrayType() && (this.initialization.resolvedType == NullBinding || this.initialization instanceof CastExpression && ((CastExpression)this.initialization).innermostCastedExpression().resolvedType == NullBinding)) {
                        codeStream.checkcast(this.binding.type);
                    }
                    codeStream.store(this.binding, false);
                    if (this.binding.initializationCount == 0) {
                        this.binding.recordInitializationStartPC(codeStream.position);
                    }
                } else if (this.binding.type == LongBinding || this.binding.type == DoubleBinding) {
                    codeStream.pop2();
                } else {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public int getKind() {
        return 4;
    }

    public void resolve(BlockScope scope) {
        TypeBinding variableType = this.type.resolveType(scope, true);
        this.checkModifiers();
        if (variableType != null) {
            if (variableType == VoidBinding) {
                scope.problemReporter().variableTypeCannotBeVoid(this);
                return;
            }
            if (variableType.isArrayType() && ((ArrayBinding)variableType).leafComponentType == VoidBinding) {
                scope.problemReporter().variableTypeCannotBeVoidArray(this);
                return;
            }
        }
        Binding existingVariable = scope.getBinding(this.name, 3, (InvocationSite)this, false);
        boolean shouldInsertInScope = true;
        if (existingVariable != null && existingVariable.isValidBinding()) {
            if (existingVariable instanceof LocalVariableBinding && this.hiddenVariableDepth == 0) {
                shouldInsertInScope = false;
                scope.problemReporter().redefineLocal(this);
            } else {
                scope.problemReporter().localVariableHiding(this, existingVariable, false);
            }
        }
        if (shouldInsertInScope) {
            if ((this.modifiers & 0x10) != 0 && this.initialization == null) {
                this.modifiers |= 0x4000000;
            }
            this.binding = new LocalVariableBinding(this, variableType, this.modifiers, false);
            scope.addLocalVariable(this.binding);
            this.binding.setConstant(NotAConstant);
        }
        if (variableType == null) {
            if (this.initialization != null) {
                this.initialization.resolveType(scope);
            }
            return;
        }
        if (this.initialization != null) {
            if (this.initialization instanceof ArrayInitializer) {
                TypeBinding initializationType = this.initialization.resolveTypeExpecting(scope, variableType);
                if (initializationType != null) {
                    ((ArrayInitializer)this.initialization).binding = (ArrayBinding)initializationType;
                    this.initialization.computeConversion(scope, variableType, initializationType);
                }
            } else {
                this.initialization.setExpectedType(variableType);
                TypeBinding initializationType = this.initialization.resolveType(scope);
                if (initializationType != null) {
                    if (variableType != initializationType) {
                        scope.compilationUnitScope().recordTypeConversion(variableType, initializationType);
                    }
                    if (this.initialization.isConstantValueOfTypeAssignableToType(initializationType, variableType) || variableType.isBaseType() && BaseTypeBinding.isWidening(variableType.id, initializationType.id) || initializationType.isCompatibleWith(variableType)) {
                        this.initialization.computeConversion(scope, variableType, initializationType);
                        if (initializationType.needsUncheckedConversion(variableType)) {
                            scope.problemReporter().unsafeTypeConversion(this.initialization, initializationType, variableType);
                        }
                    } else if (scope.isBoxingCompatibleWith(initializationType, variableType) || initializationType.isBaseType() && scope.compilerOptions().sourceLevel >= 0x310000L && !variableType.isBaseType() && this.initialization.isConstantValueOfTypeAssignableToType(initializationType, scope.environment().computeBoxingType(variableType))) {
                        this.initialization.computeConversion(scope, variableType, initializationType);
                    } else {
                        scope.problemReporter().typeMismatchError(initializationType, variableType, this.initialization);
                    }
                }
            }
            if (this.binding != null) {
                this.binding.setConstant(this.binding.isFinal() ? this.initialization.constant.castTo((variableType.id << 4) + this.initialization.constant.typeID()) : NotAConstant);
            }
        }
        if (this.binding != null) {
            LocalDeclaration.resolveAnnotations(scope, this.annotations, this.binding);
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.type.traverse(visitor, scope);
            if (this.initialization != null) {
                this.initialization.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }
}

